@echo off
if "%OS%" == "Windows_NT" setlocal
rem ------------------------------------------------------
rem Start script for the Network Data Model Editor
rem Environment Variable Prerequisites
rem
rem   ORACLE_HOME     Oracle database installation home.
rem ------------------------------------------------------

if not "%ORACLE_HOME%" =="" goto gotHome
echo The ORACLE_HOME environment variable is not defined.
echo This environment variable is needed to run this program.
goto end

:gotHome
if exist "%ORACLE_HOME%\lib\xmlparserv2.jar" goto moreCheck
echo Can't find xmlparserv2.jar.
echo This file is needed to run this program.
goto end

:moreCheck
if exist "%ORACLE_HOME%\jdbc\lib\ojdbc6.jar" goto oneMoreCheck
echo Can't find ojdbc6.jar.
echo This file is needed to run this program.
goto end

:oneMoreCheck
if exist "%ORACLE_HOME%\rdbms\jlib\xdb.jar" goto yetAnotherCheck
echo Can't find xdb.jar.
echo This file is needed to run this program.
goto end


:yetAnotherCheck
if exist "%ORACLE_HOME%\jdk\bin\java" goto doneCheck
echo Can't find java interpreter.
echo Java interpreter is needed to run this program.
goto end


:doneCheck
set JARS=%ORACLE_HOME%\lib\xmlparserv2.jar
set JARS=%ORACLE_HOME%\rdbms\jlib\xdb.jar
set JARS=%JARS%;%ORACLE_HOME%\jdbc\lib\ojdbc6.jar

rem Set locations of required jar files as appropriate.

set JARS=%JARS%;%ORACLE_HOME%\md\jlib\sdondme.jar
set JARS=%JARS%;%ORACLE_HOME%\md\jlib/sdoapi.jar
set JARS=%JARS%;%ORACLE_HOME%\md\jlib/sdonm.jar
set JARS=%JARS%;%ORACLE_HOME%\md\jlib/sdoutl.jar

set JAVA_PARAMS=-Xms512M -Xmx512M
set EDITOR_CLASS=oracle.spatial.network.editor.NetworkEditor

@echo on

%ORACLE_HOME%\jdk\bin\java %JAVA_PARAMS% -cp %JARS% %EDITOR_CLASS% 


:end

